<?php
require_once __DIR__ . '/../includes/app.php';

ensure_session();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: register.php');
    exit;
}

if (!valid_csrf($_POST['_token'] ?? null)) {
    set_flash('error', 'Session expirée. Veuillez réessayer.');
    header('Location: register.php');
    exit;
}

$rateKey = rate_limit_key('admin_register');
if (hit_rate_limit($rateKey, 3, 300)) {
    set_flash('error', 'Trop de tentatives. Réessayez plus tard.');
    header('Location: register.php');
    exit;
}

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$confirmation = $_POST['password_confirmation'] ?? '';
$token = trim($_POST['secret_token'] ?? '');

$errors = [];
$old = ['email' => $email];

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = 'Adresse courriel invalide.';
}

if (strlen($password) < 12) {
    $errors[] = 'Le mot de passe doit comporter au moins 12 caractères.';
}

if ($password !== $confirmation) {
    $errors[] = 'Les mots de passe ne correspondent pas.';
}

if (!hash_equals(auth_secret_token(), $token)) {
    $errors[] = 'Jeton secret incorrect.';
}

if ($errors) {
    set_flash('error', 'Impossible de créer le compte.', $errors, $old);
    header('Location: register.php');
    exit;
}

try {
    $pdo = db();
    $stmt = $pdo->prepare('SELECT id FROM admin_users WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);

    if ($stmt->fetch()) {
        set_flash('error', 'Impossible de créer le compte.', [], $old);
        header('Location: register.php');
        exit;
    }

    $insert = $pdo->prepare('INSERT INTO admin_users (email, password_hash) VALUES (:email, :password_hash)');
    $insert->execute([
        'email' => $email,
        'password_hash' => password_hash($password, PASSWORD_DEFAULT),
    ]);

    reset_rate_limit($rateKey);
    set_flash('success', 'Compte créé. Vous pouvez vous connecter.');
    header('Location: login.php');
    exit;
} catch (Throwable $exception) {
    error_log($exception->getMessage());
    set_flash('error', 'Erreur lors de la création du compte.', [], $old);
    header('Location: register.php');
    exit;
}
