<?php
require_once __DIR__ . '/../includes/app.php';

ensure_session();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login.php');
    exit;
}

if (!valid_csrf($_POST['_token'] ?? null)) {
    set_flash('error', 'Session expirée. Veuillez réessayer.');
    header('Location: login.php');
    exit;
}

$rateKey = rate_limit_key('admin_login');
if (hit_rate_limit($rateKey, 5, 300)) {
    set_flash('error', 'Trop de tentatives. Réessayez plus tard.');
    header('Location: login.php');
    exit;
}

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

$errors = [];
$old = ['email' => $email];

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = 'Adresse courriel invalide.';
}

if ($password === '') {
    $errors[] = 'Le mot de passe est requis.';
}

if ($errors) {
    set_flash('error', 'Connexion impossible.', $errors, $old);
    header('Location: login.php');
    exit;
}

try {
    $pdo = db();
    $stmt = $pdo->prepare('SELECT id, password_hash FROM admin_users WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if (!$user || !password_verify($password, $user['password_hash'])) {
        set_flash('error', 'Identifiants incorrects.', [], $old);
        header('Location: login.php');
        exit;
    }

    session_regenerate_id(true);
    login_user((int) $user['id']);
    reset_rate_limit($rateKey);
    set_flash('success', 'Connexion réussie.');
    header('Location: dashboard.php');
    exit;
} catch (Throwable $exception) {
    error_log($exception->getMessage());
    set_flash('error', 'Erreur lors de la connexion.', [], $old);
    header('Location: login.php');
    exit;
}
