<?php
require_once __DIR__ . '/../includes/app.php';

ensure_session();
if (current_user_id()) {
    header('Location: dashboard.php');
    exit;
}

$flash = consume_flash();
$flashStatus = $flash['status'] ?? null;
$flashMessage = $flash['message'] ?? null;
$formErrors = $flash['errors'] ?? [];
$old = $flash['old'] ?? [];
$logoPath = theme_logo_path();

function old_value(string $key): string
{
    global $old;
    return htmlspecialchars($old[$key] ?? '', ENT_QUOTES);
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Connexion administrateur</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <?= theme_style_tag(); ?>
</head>
<body>
  <div class="page-header">
    <img src="<?= htmlspecialchars($logoPath, ENT_QUOTES); ?>" alt="Logo WELMS">
    <div>
      <h1>Connexion administrateur</h1>
      <h2>Accéder au tableau de bord</h2>
    </div>
  </div>

  <div class="page-actions">
    <a href="index.php">Retour au formulaire</a>
    <a href="register.php">Nouveau compte</a>
  </div>

  <?php if ($flashMessage): ?>
    <div class="alert <?= $flashStatus === 'success' ? 'alert-success' : 'alert-error'; ?>">
      <?= htmlspecialchars($flashMessage, ENT_QUOTES); ?>
    </div>
  <?php endif; ?>

  <?php if ($formErrors): ?>
    <div class="alert alert-error">
      <p>Veuillez corriger les erreurs suivantes :</p>
      <ul>
        <?php foreach ($formErrors as $error): ?>
          <li><?= htmlspecialchars($error, ENT_QUOTES); ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <form class="auth-card" action="login_handler.php" method="post" novalidate>
    <?= csrf_field(); ?>
    <div class="form-row">
      <div class="form-group">
        <label for="email">Courriel *</label>
        <input type="email" id="email" name="email" value="<?= old_value('email'); ?>" required>
      </div>
    </div>

    <div class="form-row">
      <div class="form-group">
        <label for="password">Mot de passe *</label>
        <input type="password" id="password" name="password" required>
      </div>
    </div>

    <div class="submit-row">
      <button type="submit">Se connecter</button>
    </div>
  </form>
</body>
</html>
