<?php
require_once __DIR__ . '/../includes/app.php';
require_once __DIR__ . '/../includes/i18n.php';

ensure_session();
$flash = consume_flash();

$requestedLang = $_GET['lang'] ?? null;
if ($requestedLang !== null) {
    $resolved = resolve_language($requestedLang);
    $_SESSION['preferred_lang'] = $resolved;
    $lang = $resolved;
} else {
    $lang = resolve_language($flash['extras']['lang'] ?? $_SESSION['preferred_lang'] ?? null);
}

$flashStatus = $flash['status'] ?? null;
$flashMessage = $flash['message'] ?? null;
$formErrors = $flash['errors'] ?? [];
$old = $flash['old'] ?? [];

$logoPath = theme_logo_path();
$availableLanguages = supported_languages();

function old_value(string $key): string
{
    global $old;
    return htmlspecialchars($old[$key] ?? '', ENT_QUOTES);
}

function checked(string $key, string $value): string
{
    global $old;
    return isset($old[$key]) && $old[$key] === $value ? 'checked' : '';
}

function label_text(string $field, string $lang, bool $required = false): string
{
    $text = translate('labels.' . $field, $lang);
    return htmlspecialchars($text . ($required ? ' *' : ''), ENT_QUOTES);
}

$requiredFields = ['nom_entreprise', 'courriel_entreprise', 'resp_cf', 'date_signature', 'nom_signataire'];
$formConfig = [
    'required' => $requiredFields,
    'labels' => array_combine(
        $requiredFields,
        array_map(fn($field) => translate('labels.' . $field, $lang), $requiredFields)
    ),
    'messages' => [
        'summary' => translate('errors.summary', $lang),
        'required' => translate('errors.required', $lang),
        'email' => translate('errors.email', $lang),
    ],
    'lang' => $lang,
];
?>
<!DOCTYPE html>
<html lang="<?= htmlspecialchars($lang, ENT_QUOTES); ?>">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars(translate('page.title', $lang), ENT_QUOTES); ?></title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <?= theme_style_tag(); ?>
</head>
<body>

  <div class="page-header">
    <img src="<?= htmlspecialchars($logoPath, ENT_QUOTES); ?>" alt="Logo WELMS">
    <div>
      <h1><?= htmlspecialchars(translate('page.title', $lang), ENT_QUOTES); ?></h1>
      <h2><?= htmlspecialchars(translate('page.subtitle', $lang), ENT_QUOTES); ?></h2>
    </div>
  </div>

  <div class="page-actions">
    <?php foreach ($availableLanguages as $available): ?>
      <?php if ($available === $lang): ?>
        <span class="language-pill"><?= htmlspecialchars(strtoupper($available), ENT_QUOTES); ?></span>
      <?php else: ?>
        <a href="?lang=<?= htmlspecialchars($available, ENT_QUOTES); ?>" class="language-pill alt">
          <?= htmlspecialchars(strtoupper($available), ENT_QUOTES); ?>
        </a>
      <?php endif; ?>
    <?php endforeach; ?>
  </div>

  <div class="page-actions">
    <?php if (current_user_id()): ?>
      <a href="dashboard.php"><?= htmlspecialchars(translate('buttons.dashboard', $lang), ENT_QUOTES); ?></a>
      <a href="logout.php"><?= htmlspecialchars(translate('buttons.logout', $lang), ENT_QUOTES); ?></a>
    <?php else: ?>
      <a href="login.php"><?= htmlspecialchars(translate('buttons.login', $lang), ENT_QUOTES); ?></a>
      <a href="register.php"><?= htmlspecialchars(translate('buttons.register', $lang), ENT_QUOTES); ?></a>
    <?php endif; ?>
  </div>

  <?php if ($flashMessage): ?>
    <div class="alert <?= $flashStatus === 'success' ? 'alert-success' : 'alert-error'; ?>">
      <?= htmlspecialchars($flashMessage, ENT_QUOTES); ?>
    </div>
  <?php endif; ?>

  <?php if ($formErrors): ?>
    <div class="alert alert-error">
      <p><?= htmlspecialchars(translate('errors.summary', $lang), ENT_QUOTES); ?></p>
      <ul>
        <?php foreach ($formErrors as $error): ?>
          <li><?= htmlspecialchars($error, ENT_QUOTES); ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <div id="client-errors" class="alert alert-error hidden"></div>

  <form id="welms-form" action="submit.php" method="post" novalidate>
    <?= csrf_field(); ?>
    <input type="hidden" name="lang" value="<?= htmlspecialchars($lang, ENT_QUOTES); ?>">

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.general', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="nom_entreprise">
          <label for="nom_entreprise"><?= label_text('nom_entreprise', $lang, true); ?></label>
          <input type="text" id="nom_entreprise" name="nom_entreprise" value="<?= old_value('nom_entreprise'); ?>" required maxlength="255">
        </div>
        <div class="form-group" data-field="ville">
          <label for="ville"><?= label_text('ville', $lang); ?></label>
          <input type="text" id="ville" name="ville" value="<?= old_value('ville'); ?>" maxlength="120">
        </div>
        <div class="form-group" data-field="province">
          <label for="province"><?= label_text('province', $lang); ?></label>
          <input type="text" id="province" name="province" value="<?= old_value('province'); ?>" maxlength="120">
        </div>
        <div class="form-group" data-field="code_postal">
          <label for="code_postal"><?= label_text('code_postal', $lang); ?></label>
          <input type="text" id="code_postal" name="code_postal" value="<?= old_value('code_postal'); ?>" maxlength="30">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="courriel_entreprise">
          <label for="courriel_entreprise"><?= label_text('courriel_entreprise', $lang, true); ?></label>
          <input type="email" id="courriel_entreprise" name="courriel_entreprise" value="<?= old_value('courriel_entreprise'); ?>" required maxlength="190">
        </div>
        <div class="form-group" data-field="type_entreprise">
          <label for="type_entreprise"><?= label_text('type_entreprise', $lang); ?></label>
          <input type="text" id="type_entreprise" name="type_entreprise" value="<?= old_value('type_entreprise'); ?>" maxlength="190">
        </div>
        <div class="form-group" data-field="etablie_depuis">
          <label for="etablie_depuis"><?= label_text('etablie_depuis', $lang); ?></label>
          <input type="text" id="etablie_depuis" name="etablie_depuis" placeholder="<?= htmlspecialchars(translate('placeholders.etablie_depuis', $lang), ENT_QUOTES); ?>" value="<?= old_value('etablie_depuis'); ?>" maxlength="50">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="mode_paiement">
          <label for="mode_paiement"><?= label_text('mode_paiement', $lang); ?></label>
          <input type="text" id="mode_paiement" name="mode_paiement" value="<?= old_value('mode_paiement'); ?>" maxlength="190">
        </div>
        <div class="form-group" data-field="livrera">
          <label for="livrera"><?= label_text('livrera', $lang); ?></label>
          <input type="text" id="livrera" name="livrera" value="<?= old_value('livrera'); ?>" maxlength="255">
        </div>
      </div>
    </fieldset>

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.delivery', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="ville_2">
          <label for="ville_2"><?= label_text('ville_2', $lang); ?></label>
          <input type="text" id="ville_2" name="ville_2" value="<?= old_value('ville_2'); ?>" maxlength="120">
        </div>
        <div class="form-group" data-field="province_2">
          <label for="province_2"><?= label_text('province_2', $lang); ?></label>
          <input type="text" id="province_2" name="province_2" value="<?= old_value('province_2'); ?>" maxlength="120">
        </div>
        <div class="form-group" data-field="code_postal_2">
          <label for="code_postal_2"><?= label_text('code_postal_2', $lang); ?></label>
          <input type="text" id="code_postal_2" name="code_postal_2" value="<?= old_value('code_postal_2'); ?>" maxlength="30">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="tel_2">
          <label for="tel_2"><?= label_text('tel_2', $lang); ?></label>
          <input type="tel" id="tel_2" name="tel_2" value="<?= old_value('tel_2'); ?>" maxlength="60">
        </div>
        <div class="form-group" data-field="courriel_2">
          <label for="courriel_2"><?= label_text('courriel_2', $lang); ?></label>
          <input type="email" id="courriel_2" name="courriel_2" value="<?= old_value('courriel_2'); ?>" maxlength="190">
        </div>
      </div>
    </fieldset>

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.contacts', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="resp_cf">
          <label for="resp_cf"><?= label_text('resp_cf', $lang, true); ?></label>
          <input type="text" id="resp_cf" name="resp_cf" placeholder="<?= htmlspecialchars(translate('placeholders.contact', $lang), ENT_QUOTES); ?>" value="<?= old_value('resp_cf'); ?>" required maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="resp_achats">
          <label for="resp_achats"><?= label_text('resp_achats', $lang); ?></label>
          <input type="text" id="resp_achats" name="resp_achats" placeholder="<?= htmlspecialchars(translate('placeholders.contact', $lang), ENT_QUOTES); ?>" value="<?= old_value('resp_achats'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="resp_tech">
          <label for="resp_tech"><?= label_text('resp_tech', $lang); ?></label>
          <input type="text" id="resp_tech" name="resp_tech" placeholder="<?= htmlspecialchars(translate('placeholders.contact', $lang), ENT_QUOTES); ?>" value="<?= old_value('resp_tech'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="president">
          <label for="president"><?= label_text('president', $lang); ?></label>
          <input type="text" id="president" name="president" placeholder="<?= htmlspecialchars(translate('placeholders.contact', $lang), ENT_QUOTES); ?>" value="<?= old_value('president'); ?>" maxlength="255">
        </div>
      </div>
    </fieldset>

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.extra', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="nb_employes">
          <label for="nb_employes"><?= label_text('nb_employes', $lang); ?></label>
          <input type="number" id="nb_employes" name="nb_employes" min="0" value="<?= old_value('nb_employes'); ?>">
        </div>
        <div class="form-group" data-field="type_industrie">
          <label for="type_industrie"><?= label_text('type_industrie', $lang); ?></label>
          <input type="text" id="type_industrie" name="type_industrie" value="<?= old_value('type_industrie'); ?>" maxlength="190">
        </div>
      </div>
    </fieldset>

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.references', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="ref1_nom">
          <label for="ref1_nom"><?= label_text('ref1_nom', $lang); ?></label>
          <input type="text" id="ref1_nom" name="ref1_nom" value="<?= old_value('ref1_nom'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref1_personne">
          <label for="ref1_personne"><?= label_text('ref1_personne', $lang); ?></label>
          <input type="text" id="ref1_personne" name="ref1_personne" value="<?= old_value('ref1_personne'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref1_tel">
          <label for="ref1_tel"><?= label_text('ref1_tel', $lang); ?></label>
          <input type="tel" id="ref1_tel" name="ref1_tel" value="<?= old_value('ref1_tel'); ?>" maxlength="60">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="ref2_nom">
          <label for="ref2_nom"><?= label_text('ref2_nom', $lang); ?></label>
          <input type="text" id="ref2_nom" name="ref2_nom" value="<?= old_value('ref2_nom'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref2_personne">
          <label for="ref2_personne"><?= label_text('ref2_personne', $lang); ?></label>
          <input type="text" id="ref2_personne" name="ref2_personne" value="<?= old_value('ref2_personne'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref2_tel">
          <label for="ref2_tel"><?= label_text('ref2_tel', $lang); ?></label>
          <input type="tel" id="ref2_tel" name="ref2_tel" value="<?= old_value('ref2_tel'); ?>" maxlength="60">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="ref3">
          <label for="ref3"><?= label_text('ref3', $lang); ?></label>
          <input type="text" id="ref3" name="ref3" value="<?= old_value('ref3'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref4">
          <label for="ref4"><?= label_text('ref4', $lang); ?></label>
          <input type="text" id="ref4" name="ref4" value="<?= old_value('ref4'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="ref1_2">
          <label for="ref1_2"><?= label_text('ref1_2', $lang); ?></label>
          <input type="text" id="ref1_2" name="ref1_2" value="<?= old_value('ref1_2'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref2_2">
          <label for="ref2_2"><?= label_text('ref2_2', $lang); ?></label>
          <input type="text" id="ref2_2" name="ref2_2" value="<?= old_value('ref2_2'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="ref1_3">
          <label for="ref1_3"><?= label_text('ref1_3', $lang); ?></label>
          <input type="text" id="ref1_3" name="ref1_3" value="<?= old_value('ref1_3'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="ref2_3">
          <label for="ref2_3"><?= label_text('ref2_3', $lang); ?></label>
          <input type="text" id="ref2_3" name="ref2_3" value="<?= old_value('ref2_3'); ?>" maxlength="255">
        </div>
      </div>
    </fieldset>

    <fieldset>
      <legend><?= htmlspecialchars(translate('sections.authorization', $lang), ENT_QUOTES); ?></legend>

      <div class="form-row">
        <div class="form-group" data-field="date_signature">
          <label for="date_signature"><?= label_text('date_signature', $lang, true); ?></label>
          <input type="date" id="date_signature" name="date_signature" value="<?= old_value('date_signature'); ?>" required>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="nom_entreprise_aut">
          <label for="nom_entreprise_aut"><?= label_text('nom_entreprise_aut', $lang); ?></label>
          <input type="text" id="nom_entreprise_aut" name="nom_entreprise_aut" value="<?= old_value('nom_entreprise_aut'); ?>" maxlength="255">
        </div>
        <div class="form-group" data-field="nom_signataire">
          <label for="nom_signataire"><?= label_text('nom_signataire', $lang, true); ?></label>
          <input type="text" id="nom_signataire" name="nom_signataire" value="<?= old_value('nom_signataire'); ?>" required maxlength="190">
        </div>
        <div class="form-group" data-field="titre_signataire">
          <label for="titre_signataire"><?= label_text('titre_signataire', $lang); ?></label>
          <input type="text" id="titre_signataire" name="titre_signataire" value="<?= old_value('titre_signataire'); ?>" maxlength="190">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="adresse_fact">
          <label for="adresse_fact"><?= label_text('adresse_fact', $lang); ?></label>
          <input type="text" id="adresse_fact" name="adresse_fact" value="<?= old_value('adresse_fact'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="adresse_diff">
          <label for="adresse_diff"><?= label_text('adresse_diff', $lang); ?></label>
          <input type="text" id="adresse_diff" name="adresse_diff" value="<?= old_value('adresse_diff'); ?>" maxlength="255">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="tel1">
          <label for="tel1"><?= label_text('tel1', $lang); ?></label>
          <input type="tel" id="tel1" name="tel1" value="<?= old_value('tel1'); ?>" maxlength="60">
        </div>
        <div class="form-group" data-field="fax1">
          <label for="fax1"><?= label_text('fax1', $lang); ?></label>
          <input type="tel" id="fax1" name="fax1" value="<?= old_value('fax1'); ?>" maxlength="60">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="exotaxes">
          <label><?= label_text('exotaxes', $lang); ?></label>
          <div class="inline-options">
            <label>
              <input type="radio" name="exotaxes" value="oui" <?= checked('exotaxes', 'oui'); ?>>
              <?= htmlspecialchars(translate('options.yes', $lang), ENT_QUOTES); ?>
            </label>
            <label>
              <input type="radio" name="exotaxes" value="non" <?= checked('exotaxes', 'non'); ?>>
              <?= htmlspecialchars(translate('options.no', $lang), ENT_QUOTES); ?>
            </label>
          </div>
        </div>
      </div>

      <div class="form-row">
        <div class="form-group" data-field="text3">
          <label for="text3"><?= label_text('text3', $lang); ?></label>
          <textarea id="text3" name="text3" maxlength="2000"><?= old_value('text3'); ?></textarea>
        </div>
      </div>
    </fieldset>

    <div class="submit-row">
      <button type="submit"><?= htmlspecialchars(translate('buttons.submit', $lang), ENT_QUOTES); ?></button>
    </div>
  </form>

  <script>
    window.formConfig = <?= json_encode($formConfig, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT); ?>;
  </script>
  <script src="assets/js/form.js" defer></script>
</body>
</html>
