<?php
require_once __DIR__ . '/../includes/app.php';

ensure_session();
require_auth();

$flash = consume_flash();
$flashStatus = $flash['status'] ?? null;
$flashMessage = $flash['message'] ?? null;
$logoPath = theme_logo_path();

$pdo = db();

$userStmt = $pdo->prepare('SELECT email FROM admin_users WHERE id = :id');
$userStmt->execute(['id' => current_user_id()]);
$currentUser = $userStmt->fetch();

$page = max(1, (int) ($_GET['page'] ?? 1));
$perPage = 25;

$total = (int) $pdo->query('SELECT COUNT(*) AS total FROM welms_applications')->fetchColumn();
$totalPages = max(1, (int) ceil($total / $perPage));
$page = min($page, $totalPages);
$offset = ($page - 1) * $perPage;

$appStmt = $pdo->prepare('SELECT id, nom_entreprise, ville, courriel_entreprise, nb_employes, date_signature, created_at, type_industrie, mode_paiement, tel1 FROM welms_applications ORDER BY created_at DESC LIMIT :limit OFFSET :offset');
$appStmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$appStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$appStmt->execute();
$applications = $appStmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Tableau de bord WELMS</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <?= theme_style_tag(); ?>
</head>
<body>
  <div class="page-header">
    <img src="<?= htmlspecialchars($logoPath, ENT_QUOTES); ?>" alt="Logo WELMS">
    <div>
      <h1>Tableau de bord</h1>
      <h2>Bienvenue <?= htmlspecialchars($currentUser['email'] ?? 'Admin', ENT_QUOTES); ?></h2>
    </div>
  </div>

  <div class="page-actions">
    <a href="index.php">Formulaire public</a>
    <a href="logout.php">Déconnexion</a>
  </div>

  <?php if ($flashMessage): ?>
    <div class="alert <?= $flashStatus === 'success' ? 'alert-success' : 'alert-error'; ?>">
      <?= htmlspecialchars($flashMessage, ENT_QUOTES); ?>
    </div>
  <?php endif; ?>

  <div class="dashboard-card">
    <h3>Total des demandes : <?= $total; ?></h3>
    <?php if (!$applications): ?>
      <p>Aucune demande enregistrée pour le moment.</p>
    <?php else: ?>
      <div style="overflow-x:auto;">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>Entreprise</th>
              <th>Ville</th>
              <th>Courriel</th>
              <th>Employés</th>
              <th>Date signature</th>
              <th>Créé le</th>
              <th>Détails</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($applications as $app): ?>
              <tr>
                <td><?= htmlspecialchars((string) $app['id'], ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['nom_entreprise'], ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['ville'] ?? '-', ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['courriel_entreprise'], ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['nb_employes'] !== null ? (string) $app['nb_employes'] : '-', ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['date_signature'], ENT_QUOTES); ?></td>
                <td><?= htmlspecialchars($app['created_at'], ENT_QUOTES); ?></td>
                <td>
                  <details>
                    <summary>Voir</summary>
                    <ul class="details-list">
                      <li><strong>Industrie :</strong> <?= htmlspecialchars($app['type_industrie'] ?? '-', ENT_QUOTES); ?></li>
                      <li><strong>Mode paiement :</strong> <?= htmlspecialchars($app['mode_paiement'] ?? '-', ENT_QUOTES); ?></li>
                      <li><strong>Téléphone :</strong> <?= htmlspecialchars($app['tel1'] ?? '-', ENT_QUOTES); ?></li>
                    </ul>
                  </details>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <?php if ($totalPages > 1): ?>
        <div class="pagination">
          <?php if ($page > 1): ?>
            <a href="?page=<?= $page - 1; ?>">&laquo; Précédent</a>
          <?php else: ?>
            <span class="disabled">&laquo; Précédent</span>
          <?php endif; ?>

          <span>Page <?= $page; ?> / <?= $totalPages; ?></span>

          <?php if ($page < $totalPages): ?>
            <a href="?page=<?= $page + 1; ?>">Suivant &raquo;</a>
          <?php else: ?>
            <span class="disabled">Suivant &raquo;</span>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>
</body>
</html>
