(function () {
  const form = document.getElementById('welms-form');
  if (!form) {
    return;
  }

  const config = window.formConfig || {};
  const summaryBox = document.getElementById('client-errors');
  const requiredFields = config.required || [];
  const labels = config.labels || {};
  const messages = config.messages || {};

  function showSummary(errors) {
    if (!summaryBox) {
      return;
    }

    if (!errors.length) {
      summaryBox.classList.add('hidden');
      summaryBox.innerHTML = '';
      return;
    }

    summaryBox.innerHTML = '';
    const intro = document.createElement('p');
    intro.textContent = messages.summary || 'Veuillez corriger les erreurs ci-dessous.';
    summaryBox.appendChild(intro);

    const list = document.createElement('ul');
    errors.forEach((err) => {
      const item = document.createElement('li');
      item.textContent = err;
      list.appendChild(item);
    });

    summaryBox.appendChild(list);
    summaryBox.classList.remove('hidden');
  }

  function clearFieldErrors() {
    form.querySelectorAll('.error-message').forEach((node) => node.remove());
    form.querySelectorAll('.input-error').forEach((node) => node.classList.remove('input-error'));
  }

  function addFieldError(fieldName, message) {
    const group = form.querySelector(`[data-field="${fieldName}"]`);
    if (!group) {
      return;
    }

    const input = group.querySelector('input, textarea, select');
    if (input) {
      input.classList.add('input-error');
    }

    const errorNode = document.createElement('div');
    errorNode.className = 'error-message';
    errorNode.textContent = message;
    group.appendChild(errorNode);
  }

  form.addEventListener('submit', (event) => {
    clearFieldErrors();
    const errors = [];

    requiredFields.forEach((fieldName) => {
      const input = form.elements[fieldName];
      if (!input || !input.value.trim()) {
        const label = labels[fieldName] || fieldName;
        const message = (messages.required || 'Le champ ":field" est requis.').replace(':field', label);
        errors.push(message);
        addFieldError(fieldName, message);
      }
    });

    const emailField = form.elements['courriel_entreprise'];
    if (emailField && emailField.value.trim()) {
      const emailPattern = /^\S+@\S+\.\S+$/;
      if (!emailPattern.test(emailField.value.trim())) {
        const label = labels['courriel_entreprise'] || 'Email';
        const message = (messages.email || 'Adresse courriel invalide.').replace(':field', label);
        errors.push(message);
        addFieldError('courriel_entreprise', message);
      }
    }

    showSummary(errors);
    if (errors.length) {
      event.preventDefault();
    }
  });
})();
