<?php

declare(strict_types=1);

function translations(): array
{
    static $translations = null;

    if ($translations !== null) {
        return $translations;
    }

    $translations = [
        'fr' => [
            'language' => 'Français',
            'page.title' => 'Ouverture de compte WELMS',
            'page.subtitle' => 'Informations sur l’entreprise',
            'sections.general' => 'Informations générales',
            'sections.delivery' => 'Adresse de livraison (si différente)',
            'sections.contacts' => 'Responsables',
            'sections.extra' => 'Informations supplémentaires',
            'sections.references' => 'Références',
            'sections.authorization' => 'Autorisation',
            'buttons.submit' => 'Soumettre',
            'buttons.login' => 'Connexion',
            'buttons.register' => 'Créer un accès',
            'buttons.dashboard' => 'Tableau de bord',
            'buttons.logout' => 'Déconnexion',
            'language.switch' => 'Langue',
            'labels.nom_entreprise' => 'Nom de l’entreprise',
            'labels.ville' => 'Ville',
            'labels.province' => 'Province',
            'labels.code_postal' => 'Code postal',
            'labels.courriel_entreprise' => 'Adresse courriel',
            'labels.type_entreprise' => 'Type d’entreprise',
            'labels.etablie_depuis' => 'Établie depuis',
            'labels.mode_paiement' => 'Mode de paiement souhaité',
            'labels.livrera' => 'Livrera (lieu / conditions)',
            'labels.ville_2' => 'Ville',
            'labels.province_2' => 'Province',
            'labels.code_postal_2' => 'Code postal',
            'labels.tel_2' => 'Téléphone / Télécopieur',
            'labels.courriel_2' => 'Adresse courriel',
            'labels.resp_cf' => 'Responsable des comptes fournisseurs (nom et courriel)',
            'labels.resp_achats' => 'Responsable des achats (nom et courriel)',
            'labels.resp_tech' => 'Responsable technique (nom et courriel)',
            'labels.president' => 'Président (nom et courriel)',
            'labels.nb_employes' => 'Nombre d’employés',
            'labels.type_industrie' => 'Votre type d’industrie',
            'labels.ref1_nom' => 'Référence 1 (nom / entreprise)',
            'labels.ref1_personne' => 'Personne ressource 1',
            'labels.ref1_tel' => 'Téléphone / Télécopieur 1',
            'labels.ref2_nom' => 'Référence 2 (nom / entreprise)',
            'labels.ref2_personne' => 'Personne ressource 2',
            'labels.ref2_tel' => 'Téléphone / Télécopieur 2',
            'labels.ref3' => 'Référence 3 (optionnelle)',
            'labels.ref4' => 'Référence 4 (optionnelle)',
            'labels.ref1_2' => 'Référence complémentaire 1_2',
            'labels.ref2_2' => 'Référence complémentaire 2_2',
            'labels.ref1_3' => 'Référence complémentaire 1_3',
            'labels.ref2_3' => 'Référence complémentaire 2_3',
            'labels.date_signature' => 'Date',
            'labels.nom_entreprise_aut' => 'Nom de l’entreprise',
            'labels.nom_signataire' => 'Nom',
            'labels.titre_signataire' => 'Titre',
            'labels.adresse_fact' => 'Adresse',
            'labels.adresse_diff' => 'Adresse (si différente)',
            'labels.tel1' => 'Téléphone',
            'labels.fax1' => 'Télécopieur',
            'labels.exotaxes' => 'Exotaxes',
            'labels.text3' => 'Commentaires / Notes',
            'options.yes' => 'Oui',
            'options.no' => 'Non',
            'placeholders.etablie_depuis' => 'Année ou date',
            'placeholders.contact' => 'Nom, courriel',
            'errors.summary' => 'Veuillez corriger les erreurs ci-dessous.',
            'errors.required' => 'Le champ « :field » est requis.',
            'errors.email' => 'Le champ « :field » doit contenir une adresse courriel valide.',
            'errors.integer' => 'Le champ « :field » doit être un nombre entier positif.',
            'errors.length' => 'Le champ « :field » ne peut dépasser :max caractères.',
            'errors.date' => 'Le champ « :field » doit être une date valide.',
            'errors.csrf' => 'La session a expiré. Veuillez réessayer.',
            'errors.rate_limited' => 'Vous avez atteint la limite de tentatives. Veuillez patienter avant de réessayer.',
            'errors.phone' => 'Le champ « :field » doit contenir un numéro valide.',
            'errors.invalid_choice' => 'La valeur du champ « :field » est invalide.',
            'errors.server' => 'Une erreur est survenue. Veuillez réessayer plus tard.',
            'messages.success' => 'Demande enregistrée avec succès.',
        ],
        'en' => [
            'language' => 'English',
            'page.title' => 'WELMS Account Opening',
            'page.subtitle' => 'Company information',
            'sections.general' => 'General information',
            'sections.delivery' => 'Shipping address (if different)',
            'sections.contacts' => 'Contacts',
            'sections.extra' => 'Additional information',
            'sections.references' => 'References',
            'sections.authorization' => 'Authorization',
            'buttons.submit' => 'Submit',
            'buttons.login' => 'Log in',
            'buttons.register' => 'Create admin access',
            'buttons.dashboard' => 'Dashboard',
            'buttons.logout' => 'Log out',
            'language.switch' => 'Language',
            'labels.nom_entreprise' => 'Company name',
            'labels.ville' => 'City',
            'labels.province' => 'Province / State',
            'labels.code_postal' => 'Postal code',
            'labels.courriel_entreprise' => 'Email address',
            'labels.type_entreprise' => 'Business type',
            'labels.etablie_depuis' => 'Established since',
            'labels.mode_paiement' => 'Preferred payment method',
            'labels.livrera' => 'Delivery details (location / conditions)',
            'labels.ville_2' => 'City',
            'labels.province_2' => 'Province / State',
            'labels.code_postal_2' => 'Postal code',
            'labels.tel_2' => 'Phone / Fax',
            'labels.courriel_2' => 'Email address',
            'labels.resp_cf' => 'Accounts payable contact (name and email)',
            'labels.resp_achats' => 'Purchasing contact (name and email)',
            'labels.resp_tech' => 'Technical contact (name and email)',
            'labels.president' => 'President (name and email)',
            'labels.nb_employes' => 'Number of employees',
            'labels.type_industrie' => 'Industry type',
            'labels.ref1_nom' => 'Reference 1 (name / company)',
            'labels.ref1_personne' => 'Reference contact 1',
            'labels.ref1_tel' => 'Phone / Fax 1',
            'labels.ref2_nom' => 'Reference 2 (name / company)',
            'labels.ref2_personne' => 'Reference contact 2',
            'labels.ref2_tel' => 'Phone / Fax 2',
            'labels.ref3' => 'Reference 3 (optional)',
            'labels.ref4' => 'Reference 4 (optional)',
            'labels.ref1_2' => 'Additional reference 1_2',
            'labels.ref2_2' => 'Additional reference 2_2',
            'labels.ref1_3' => 'Additional reference 1_3',
            'labels.ref2_3' => 'Additional reference 2_3',
            'labels.date_signature' => 'Date',
            'labels.nom_entreprise_aut' => 'Company name',
            'labels.nom_signataire' => 'Name',
            'labels.titre_signataire' => 'Title',
            'labels.adresse_fact' => 'Address',
            'labels.adresse_diff' => 'Address (if different)',
            'labels.tel1' => 'Phone',
            'labels.fax1' => 'Fax',
            'labels.exotaxes' => 'Exotaxes',
            'labels.text3' => 'Comments / Notes',
            'options.yes' => 'Yes',
            'options.no' => 'No',
            'placeholders.etablie_depuis' => 'Year or date',
            'placeholders.contact' => 'Name, email',
            'errors.summary' => 'Please fix the errors below.',
            'errors.required' => 'The “:field” field is required.',
            'errors.email' => 'The “:field” field must be a valid email address.',
            'errors.integer' => 'The “:field” field must be a positive integer.',
            'errors.length' => 'The “:field” field may not exceed :max characters.',
            'errors.date' => 'The “:field” field must be a valid date.',
            'errors.csrf' => 'Your session expired. Please try again.',
            'errors.rate_limited' => 'Too many attempts. Please wait before trying again.',
            'errors.phone' => 'The “:field” field must be a valid phone number.',
            'errors.invalid_choice' => 'The “:field” field contains an invalid value.',
            'errors.server' => 'Something went wrong. Please try again later.',
            'messages.success' => 'Application saved successfully.',
        ],
    ];

    return $translations;
}

function supported_languages(): array
{
    return array_keys(translations());
}

function default_language(): string
{
    return 'fr';
}

function resolve_language(?string $requested): string
{
    $requested = strtolower((string) $requested);
    $languages = supported_languages();

    return in_array($requested, $languages, true) ? $requested : default_language();
}

function translate(string $key, string $lang, array $replacements = []): string
{
    $catalogue = translations();
    $value = $catalogue[$lang][$key] ?? $catalogue[default_language()][$key] ?? $key;

    foreach ($replacements as $placeholder => $replacement) {
        $value = str_replace(':' . $placeholder, $replacement, $value);
    }

    return $value;
}
