<?php
return [
    'db' => [
        'host' => getenv('DB_HOST') ?: '127.0.0.1',
        'port' => (int) (getenv('DB_PORT') ?: 3306),
        'name' => getenv('DB_NAME') ?: 'welms',
        'user' => getenv('DB_USER') ?: 'welms_user',
        'pass' => getenv('DB_PASS') ?: 'secret',
        'options' => [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ],
    ],
    'theme' => [
        'primary_color' => getenv('PRIMARY_COLOR') ?: '#0c63e4',
        'logo_path' => getenv('LOGO_PATH') ?: 'assets/img/logo.svg',
    ],
    'auth' => [
        'secret_token' => getenv('ADMIN_SECRET') ?: 'change-me-token',
        'session_key' => 'welms_admin_id',
    ],
    'mail' => [
        'host' => getenv('SMTP_HOST') ?: '',
        'port' => (int) (getenv('SMTP_PORT') ?: 587),
        'username' => getenv('SMTP_USER') ?: '',
        'password' => getenv('SMTP_PASS') ?: '',
        'encryption' => getenv('SMTP_ENCRYPTION') ?: 'tls', // none|tls|ssl
        'from_email' => getenv('MAIL_FROM_EMAIL') ?: 'no-reply@welms.test',
        'from_name' => getenv('MAIL_FROM_NAME') ?: 'WELMS Notifications',
        'to_email' => getenv('MAIL_TO_EMAIL') ?: '',
        'to_name' => getenv('MAIL_TO_NAME') ?: 'Administrateur WELMS',
        'ca_file' => getenv('SMTP_CA_FILE') ?: '',
    ],
];
