# WELMS Account Opening Form

Simple PHP project that captures the WELMS account opening form, stores submissions in MySQL, and provides basic client/server-side validation.

## Requirements

- PHP 8.1+ (with `pdo_mysql`, `openssl`, and `mbstring` extensions)
- MySQL 8+ (or compatible)
- Composer (optional, not required for this project)

## Setup

1. **Install dependencies** – none besides PHP extensions.
2. **Configure credentials, theme, localisation & mail**:
   - Update `config.php` or set environment variables:
     - `DB_HOST`, `DB_PORT`, `DB_NAME`, `DB_USER`, `DB_PASS`
     - `PRIMARY_COLOR` (hex) to change the UI accent
     - `LOGO_PATH` for the logo served from `public/`
     - `ADMIN_SECRET` secret token required during admin registration
     - `SMTP_HOST`, `SMTP_PORT`, `SMTP_USER`, `SMTP_PASS`, `SMTP_ENCRYPTION` (`none|tls|ssl`)
     - `MAIL_FROM_EMAIL`, `MAIL_FROM_NAME`, `MAIL_TO_EMAIL` (comma separated for multiple recipients), `MAIL_TO_NAME`
     - `SMTP_CA_FILE` (optional) to point to a custom CA bundle for SMTP verification
3. **Create / update the schema**:
   ```sh
   mysql -u <user> -p < schema.sql
   ```
4. **Run the development server**:
   ```sh
   php -S localhost:8000 -t public
   ```
5. Open `http://localhost:8000?lang=fr` or `?lang=en`, complete the form, and submit. Successful submissions are inserted into `welms_applications` and trigger an email (when SMTP is configured).

## Admin workflow

1. Set `ADMIN_SECRET` (or edit `config.php`).
2. Visit `/register.php`, provide the secret token, and create an admin account (passwords are hashed with `password_hash`).
3. Log in via `/login.php`; authenticated users are redirected to `/dashboard.php`, which lists all client submissions.
4. Use `/logout.php` to end the session.

Only logged-in admins can view the dashboard; submissions remain open to public visitors.

## Project structure

- `public/index.php` – form UI + flash messaging
- `public/submit.php` – POST handler that validates data and persists to MySQL
- `public/login.php`, `public/register.php`, `public/dashboard.php` – admin authentication & viewer
- `public/assets/` – CSS/JS
- `includes/database.php` – shared PDO helper
- `includes/app.php` – config, theming, auth, flash, CSRF, and rate-limit helpers
- `includes/i18n.php` – translation catalog + helper functions (French/English)
- `includes/mailer.php` – SMTP client used to notify admins of new submissions
- `config.php` – database configuration (override via env vars in production)
- `schema.sql` – MySQL schema for the form data

## Validation, Localisation & Security

- Full bilingual (FR/EN) client form with language toggle, translated validation strings, and configurable accent color/logo.
- CSRF protection on every form plus per-IP rate limiting on public submissions, login, and registration.
- Client-side validation displays inline errors without blocking dialogs; server-side validation enforces length, format, and numeric constraints.
- Flash messages inform the user about success or describe validation errors (preserving their chosen language).
- Session IDs are regenerated on login/logout to prevent fixation.
- SMTP notifications are sent via a hardened TLS client with peer verification and optional custom CA support.
- Dashboard access is paginated to keep queries fast even with large datasets.

## Extending

- Hook `db()` usage into additional services or repositories if you later modularize the app.
- Replace the simple flash/session handling with a framework or templating engine as needed.
